; Using the network extention of Netlogo we will create two preferential-attachment networks and three different kinds of agents
;Green agents, grey agents, and hardliners that never change their opinion

;***************
; SETUP
;***************
extensions [nw]             ; start up the network extension


breed [AgentAs AgentA]                        ; the A breed are grey
breed [AgentBs AgentB]                        ; the B breed are green
breed [hardliners hardliner]

links-own [weight]
turtles-own [community clique]


to setup
  clear-all
  nw:generate-preferential-attachment AgentAs links n-greys k-degree [set color grey]                      ; set up a Agent group A (grey) in a preferential attachment network
  nw:generate-preferential-attachment AgentBs links n-greens k-degree [set color green]                    ; set up a Agent group B (green) in a preferential attachment network

    ask AgentBs [ if random-float 1 < group-openness [create-links-with AgentAs]]                         ; ask both networks to interconnect based on the chance of 1 < group-openness
    ask AgentAs [ if random-float 1 < group-openness [create-links-with AgentBs]]                         ; ask both networks to interconnect based on the chance of 1 < group-openness


 ask turtles [
    set size 1
    set shape "person"
    setxy random-xcor random-ycor                                                              ; move agents randomly around
  ]

  ask patches [set pcolor white]                                                             ; change to black for a black background

   ask n-of int(prop-hard * n-greys) AgentAs [set breed hardliners ]                              ; make "AgentAs" grey hardliners
   ask n-of int(prop-hard * n-greens) AgentBs [set breed hardliners ]                              ; make "AgentBs" green hardliners
   ask hardliners [set shape "person"]

  foreach nw:louvain-communities [ [comm] ->                                                      ;tell every turtle in what community they are
  ask comm [ set community comm ]
  foreach nw:maximal-cliques [ [cliq] ->                                                      ;tell every turtle in what community they are
  ask cliq [ set clique cliq ]
]
]

nw:set-context turtles links
weight-clusters nw:louvain-communities                                                           ;assign weights to links

reset-ticks
end

;to find-biggest-cliques
  ;nw:set-context turtles links
  ;highlight-clusters nw:maximal-cliques
;end

to color-communities
  nw:set-context turtles links
  color-clusters nw:louvain-communities
end

;***************
; DYNAMICS
;***************

to go
    if (all? turtles [color = green]) [stop]
    if (all? turtles [color = grey]) [stop]


  if moving [
  move
  ]
  ask turtles [interact]
  tick
end

to move ;asks a random link to die with a 1% change. And creates a random(!) link from a random agent to any other agent with a 33% chance of it becoming a strong tie
    ask one-of links
  [ if random-float 100 < 1 [die]]
  ask one-of turtles [ if random-float 100 < 1 [create-link-with one-of other turtles [set weight random 3]]]
end

to weight-clusters [ clusters ] ;gives links between clusters weight = 1 (weak tie) and links within clusters weight = 2 (strong tie). Clusters are defined by louvain-communities
  ask links [ set weight 1 ]
  let n length clusters
  let colors ifelse-value (n <= 12)
  [ n-of n remove gray remove white base-colors ]
  [ n-values n [ approximate-hsb (random 255) (255) (100 + random 100) ] ]
    (foreach clusters colors [ [cluster cluster-color] ->
      ask cluster [
        ask my-links [ if member? other-end cluster [ set weight 2 ] ]

      ]
    ])
if hub-weak [
let max-neighbors (Max [count link-neighbors] of turtles)
let hub turtles with [count link-neighbors > max-neighbors - 10]
if any? hub [
  ask hub [
    ask my-links [
      set weight 1
    ]
  ]
]
]
end

to color-clusters [ clusters ]
  ;reset all colors
  ask turtles [ set color gray - 3 ]
  ask links [ set color gray - 3 ]
  let n length clusters
  let colors ifelse-value (n <= 12)
    [ n-of n remove gray remove white base-colors ] ;; choose base colors other than white and gray
    [ n-values n [ approximate-hsb (random 255) (255) (100 + random 100) ] ] ; too many colors - pick random ones

    ; loop through the clusters and colors zipped together
    (foreach clusters colors [ [cluster cluster-color] ->
      ask cluster [ ; for each node in the cluster
        ; give the node the color of its cluster
        set color cluster-color
      ; making links slightly darker
        ask my-links [ if member? other-end cluster [ set color cluster-color - 1 ] ]

      ]
    ])
end

to interact ;aks two times, once to turn grey, once to turn green
     ask one-of turtles [
       let count-total 0
       let count-weak 0
       let count-strong 0

       set count-total count link-neighbors
       let strong (my-links) with [weight = 2]
    if any? strong [
       set count-strong count link-neighbors with [color != [color] of myself]]
       let weak (my-links) with [weight < 2]
    if any? weak [
      set count-weak count link-neighbors with [color != [color] of myself]]
    ifelse log-threshold [
       let activation-probability 1 / (1 + exp(-(count-weak - (activation-threshold * count-total)) * 5))
      if random-float 1 < activation-probability [
        if breed != hardliners [set color green]]
    ]
    [
        if count-weak >= (count-total * activation-threshold) + (random (6)) [                 ;if the agent is connected to weak ties with a different color they have to exceed the number of total links*tippingp and a random factor
       if breed != hardliners [set color green]]
    ]
     if strong-ties [   if count-strong >= threshold-strong + random 4 [                                          ;if the agent is connected to strong ties with a different color, 1 + random 4 (0-3) will result in a color change. 2 strong ties can be enough
      if breed != hardliners [set color green]]                                ;if not a hardliner change color
    ]
  ]
  if countervailing-contagion [
     ask one-of turtles [
      let count-total 0
      let count-weak 0
      let count-strong 0
      set count-total count link-neighbors
      let te (my-links) with [weight = 2]
    if any? te [
      set count-strong count link-neighbors with [color != [color] of myself]]
      let weak (my-links) with [weight < 2]
    if any? weak [
      set count-weak count link-neighbors with [color != [color] of myself]]
      ifelse log-threshold [
       let activation-probability 1 / (1 + exp(-(count-weak - (activation-threshold * count-total)) * 5))
       if random-float 1 < activation-probability [
       if breed != hardliners [set color grey]]
    ]
    [
        if count-weak >= (count-total * activation-threshold) + (random (6)) [                 ;if the agent is connected to weak ties with a different color they have to exceed the number of total links*tippingp and a random factor
        if breed != hardliners [set color grey]]
    ]
    if strong-ties [ if count-strong >= threshold-strong + random 4 [                                          ;if the agent is connected to strong ties with a different color, 1 + random 4 (0-3) will result in a color change. 2 strong ties can be enough
        if breed != hardliners [set color grey]]                                 ;if not a hardliner change color
    ]
  ]
  ]
end

to report2
  ask one-of turtles [
   let te (link-neighbors with [color != [color] of myself])
    show sum te

  ]
end
@#$#@#$#@
GRAPHICS-WINDOW
210
10
1190
991
-1
-1
12.0
1
10
1
1
1
0
0
0
1
-40
40
-40
40
0
0
1
ticks
30.0

BUTTON
1458
25
1543
69
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
1205
27
1377
60
n-greys
n-greys
2
500
200.0
1
1
agents
HORIZONTAL

SLIDER
1205
73
1377
106
n-greens
n-greens
2
500
20.0
1
1
agents
HORIZONTAL

SLIDER
1206
121
1378
154
k-degree
k-degree
0
10
6.0
1
1
edges
HORIZONTAL

SLIDER
1206
230
1401
263
group-openness
group-openness
0
1
0.05
0.01
1
percent
HORIZONTAL

BUTTON
1561
26
1648
69
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
1217
568
1296
613
Total links
count links
17
1
11

MONITOR
1214
874
1433
919
Total green agents
count turtles with [color = green]
17
1
11

SLIDER
1207
188
1403
221
prop-hard
prop-hard
0
1
0.1
0.01
1
percent
HORIZONTAL

MONITOR
1207
363
1355
408
Max Degree
Max [count link-neighbors] of turtles
17
1
11

MONITOR
1208
456
1356
501
Min Degree
min [count link-neighbors] of turtles
17
1
11

MONITOR
1216
630
1296
675
Strong ties
count links with [ weight = 2]
17
1
11

MONITOR
1305
630
1393
675
Weak ties
count links with [ weight = 1]
17
1
11

BUTTON
1531
569
1685
614
Colors communities
color-communities
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
1304
568
1393
613
Total agents
count turtles
17
1
11

PLOT
1215
697
1687
858
Change of green agents
Ticks
Green agents
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot count turtles with [color = green]"

SLIDER
1206
276
1404
309
activation-threshold
activation-threshold
0
1
0.75
0.01
1
Percent
HORIZONTAL

MONITOR
1207
315
1355
360
Number of communities
length nw:louvain-communities
0
1
11

PLOT
1373
327
1688
517
Degree distribution
Degreees
n of nodes
0.0
220.0
0.0
10.0
true
false
"" ""
PENS
"default" 0.5 1 -16777216 true "" "histogram [ count my-links ] of turtles with [color = grey]"
"pen-1" 0.5 1 -14439633 true "" "histogram [ count my-links ] of turtles with [color = green]"

MONITOR
1209
504
1357
549
Clustering Coefficient
mean [nw:clustering-coefficient] of turtles
2
1
11

MONITOR
1398
568
1507
613
mean path lenght
nw:mean-path-length
2
1
11

SLIDER
1409
276
1593
309
threshold-strong
threshold-strong
0
10
5.0
1
1
agents 
HORIZONTAL

SWITCH
1407
188
1521
221
moving
moving
0
1
-1000

SWITCH
1408
230
1521
263
strong-ties
strong-ties
0
1
-1000

SWITCH
1525
188
1715
221
log-threshold
log-threshold
1
1
-1000

SWITCH
1527
229
1716
262
countervailing-contagion
countervailing-contagion
0
1
-1000

MONITOR
1408
630
1485
675
Grey hubs
count turtles with [color = grey and count link-neighbors > (Max [count link-neighbors] of turtles - 10)]
17
1
11

MONITOR
1496
630
1581
675
Green hubs
count turtles with [color = green and count link-neighbors > (Max [count link-neighbors] of turtles - 10)]
17
1
11

SWITCH
1598
276
1716
309
hub-weak
hub-weak
0
1
-1000

MONITOR
1207
410
1355
455
median degree
median [count link-neighbors] of turtles with [color = green]
17
1
11

@#$#@#$#@
## WHAT IS IT?

The model tries to show the diffusion of a enviomental friendly complex contagion (green) againt a countervailing complex contagion (grey) in a scale-free network. It is part of a master thesis written by Till Kolligs. at Stockholm Universitetet. It makes use of the differentiation between weak and strong ties. Both colours can be seen as containers for a complex contagion. Green can be seen as a complex contagion that involves enviromental action, let it be taking the train instead of the train, sperating trash, buying ecological products etc. Can the green complex contagion diffuse in the whole network to the grey nodes? The grey nodes do not act enviromental friendly in the regards of the green nodes, they might have other perceptions of what needs to be done or are convinced of the "grey way". The "grey way" is also a complex contagion that can spead to the green. 

## HOW IT WORKS

Two scale-free networks are being created. One scale-free network consisting of grey agents and one consisting of green agents. The parameter "group openness" then defines how much overlap between the groups exist. If set to 0.00 no links between the grey and the green clusters should exist. 

Since a complex contagion needs multiple reinforcements, a colour change is triggered if the number of weak-tie network neighbours with opposing colour exceed the procentual threshold. A random factor makes the transition less deterministing, as the threshold can vary up to 5 agents.  If the threshold is set to 0.5 then the weak ties of different colour must make up more than half of all existing ties to change the nodes color + 0 to 4 agents (random for every model tick).

Strong ties, however only need "threshold-strong" + random factor (up to 3) to convince a node to change its colour. Strong and weak ties are defined by communities. Communities can be colored to be more visible by pressing the button "color communities". The model has to be reset afterwards.

First, the number of agents can be set, seperately for greys and greens. Then the number of degrees can be set. This defines how many links nodes have. If set to one, most nodes only have one edge/link. Since human networks have a tendency for transitivity, it is recommended to set this setting atleast to two to be more realistic. 

Weak ties are defined as ties that are links between louvain-communities, strong ties are defined as links within louvain-communities. 

New links that are generated have a 33% chance to be a strong tie, and 66% to be a weak tie, as they likely reach across communities.


## HOW TO USE IT

By pressing setup, the two networks according to the settings are generated. The number of communities is shown, as well as the minimum amount of links a node has and the highest amount of links a node has (min degree, max degree). The degree distribution is also shown, but it is capped to 100. If max degree is > 100 the x-axis needs to be adapted. 

The clustering coefficiant is also displayed, as well as the number of weak and strong ties and mean path lenghts. 

Finally,
the total green agents shows how many green nodes there are. The plot shows the change over time. The model stops running if the number of green agents equals 0 or all the existing turtles.


## THINGS TO NOTICE

The max degree is reduced while the model is running as links are deleted and regenerated randomly. Therefore change can be suddenly if the model is allowed to run long enough.
Smaller networks tend to have more grey hubs, larger networks tend to exist only with green hubs

## THINGS TO TRY

The user can try out the model by adjusting all the sliders. The activation thresholds (weak and strong) are the only sliders that can be adjusted while the model is running. It is encouraged to try them out! All others have to be adjusted before setting up the model. Prop-Hard stets a proportion of agents that are stubborn and never change their color. The proportion is true for both green and grey agents. 


## EXTENDING THE MODEL

The switches do the following:
*****Moving
Turns on/off that links are randomly deleted and generated

*****Strong-ties
-Turns on/off that strong ties influence agents

*****log-threshold
Turns on/off logarithmic influence of weak ties.
Change color with the chance of the log function
Log Function = 1/(1+e^-(weak ties - (activation-threshold x total amount of neighboring ties)) x 1)
(The smaller the activation threshold, the larger the chance for color change). This allows every agent to have a small chance of changing colour even if the threshold has not been reached

*****Countervailing contagion
This turns off the possibility for the grey contagion to infect green agents making them become grey

In case of a powerful computer, settings can be adjusted before the set range by using the command center. For instance: set n-greys 1000, sets the amount of grey agents to 1000

## NETLOGO FEATURES

Model can be adjusted so thresholds adjust during the simulations, or the proportion of hardliners varies.

To run large scale simulations, the NetLogo Behavioral Space can be used.
## CREDITS AND REFERENCES
http://modelingcommons.org/browse/one_model/5216 - a complex contagion model
https://ccl.northwestern.edu/netlogo/models/PreferentialAttachment - scale free networks

Laver, Michael. 2020. Agent-Based Models of Social Life: Fundamentals. 1st ed. Cambridge University Press.

Laver, Michael. 2020. Agent-Based Models of Polarization and Ethnocentrism. 1st ed. Cambridge University Press.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.3.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="experiment 500 20 0.1" repetitions="100" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>count turtles with [color = green]</metric>
    <enumeratedValueSet variable="countervailing-contagion">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="threshold-strong">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="group-openness">
      <value value="0.05"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hub-weak">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="prop-hard">
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="moving">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="n-greys">
      <value value="500"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="log-threshold">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="strong-ties">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="k-degree">
      <value value="2"/>
      <value value="4"/>
      <value value="6"/>
      <value value="8"/>
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="n-greens">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="activation-threshold">
      <value value="0.75"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment degree35 0" repetitions="100" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>count turtles with [color = green]</metric>
    <enumeratedValueSet variable="countervailing-contagion">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="threshold-strong">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="group-openness">
      <value value="0.05"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hub-weak">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="prop-hard">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="moving">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="n-greys">
      <value value="200"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="log-threshold">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="strong-ties">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="k-degree">
      <value value="2"/>
      <value value="4"/>
      <value value="6"/>
      <value value="8"/>
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="n-greens">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="activation-threshold">
      <value value="0.75"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment degree50 0" repetitions="100" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>count turtles with [color = green]</metric>
    <enumeratedValueSet variable="countervailing-contagion">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="threshold-strong">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="group-openness">
      <value value="0.05"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hub-weak">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="prop-hard">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="moving">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="n-greys">
      <value value="200"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="log-threshold">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="strong-ties">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="k-degree">
      <value value="2"/>
      <value value="4"/>
      <value value="6"/>
      <value value="8"/>
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="n-greens">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="activation-threshold">
      <value value="0.75"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment hardliners" repetitions="100" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>count turtles with [color = green]</metric>
    <enumeratedValueSet variable="countervailing-contagion">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="threshold-strong">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="group-openness">
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hub-weak">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="prop-hard">
      <value value="0"/>
      <value value="0.05"/>
      <value value="0.1"/>
      <value value="0.15"/>
      <value value="0.2"/>
      <value value="0.25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="moving">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="n-greys">
      <value value="200"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="log-threshold">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="strong-ties">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="k-degree">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="n-greens">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="activation-threshold">
      <value value="0.75"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="prophard" repetitions="100" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>count turtles with [color = green]</metric>
    <enumeratedValueSet variable="countervailing-contagion">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="threshold-strong">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="group-openness">
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hub-weak">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="moving">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="prop-hard">
      <value value="0.2"/>
      <value value="0.225"/>
      <value value="0.24"/>
      <value value="0.25"/>
      <value value="0.3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="n-greys">
      <value value="200"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="strong-ties">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="log-threshold">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="k-degree">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="activation-threshold">
      <value value="0.75"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="n-greens">
      <value value="20"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="hub weak &amp; greyyy" repetitions="100" runMetricsEveryStep="false">
    <setup>setup
ask turtles with [color = green and count link-neighbors &gt; (Max [count link-neighbors] of turtles - 10)] [set color grey]</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>count turtles with [color = green]</metric>
    <enumeratedValueSet variable="countervailing-contagion">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="threshold-strong">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="group-openness">
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hub-weak">
      <value value="false"/>
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="moving">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="prop-hard">
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="n-greys">
      <value value="200"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="strong-ties">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="log-threshold">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="k-degree">
      <value value="6.00001"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="activation-threshold">
      <value value="0.75"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="n-greens">
      <value value="20"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="countervailing onoff" repetitions="100" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>count turtles with [color = green]</metric>
    <enumeratedValueSet variable="countervailing-contagion">
      <value value="true"/>
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="threshold-strong">
      <value value="5"/>
      <value value="8"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="group-openness">
      <value value="0.05"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hub-weak">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="moving">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="prop-hard">
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="n-greys">
      <value value="200"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="strong-ties">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="log-threshold">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="k-degree">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="activation-threshold">
      <value value="0.75"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="n-greens">
      <value value="20"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment falling thres" repetitions="100" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1100"/>
    <metric>count turtles with [color = green]</metric>
    <enumeratedValueSet variable="countervailing-contagion">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="threshold-strong">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="group-openness">
      <value value="0.05"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hub-weak">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="prop-hard">
      <value value="0.15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="moving">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="n-greys">
      <value value="200"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="strong-ties">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="log-threshold">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="k-degree">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="n-greens">
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="activation-threshold">
      <value value="0.75"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
