  patches-own ;; this way turtles can recognize which patches are airports and which aren't
 [airport? ;; patches are either airports (airport? = true) or not (airport? = false)
 num-of-flights ;; so airports keep track of how many turtles have departed from them
 airport-id] ;; this helps us with the plotting.  the airport-id will be on the x-axis and the number of flights that have departed from each airport (corresponding to it's airport-id) will be on the y-axis)

globals [airport-count] ;; to help us keep track of the total number of airports and to keep the airport-id procedure increasing by 1 for each new airport created

to setup
  clear-all
  set airport-count 0 ;; because there are no airports yet!
 ask patches [set airport? false] ;; to make all the black patches not airports
    repeat initial-airports ;; use the slider to set # of initial airports
    [ask patch  random-pxcor random-pycor 
    [ set pcolor green 
      set num-of-flights 0  ;; because no flights have departed yet
      set airport-id airport-count ;; so the first airport created has an airport-id of 0
      set airport-count airport-count + 1] ] ;; we need to increase the airport-count so that next time an airport is created it will have a higher id number
    ask patches with [pcolor = green] [set airport? true] ;; to make the green patches be recognizable to turtles as airports
    crt initial-airports [set color red setxy random-xcor random-ycor ] ;; still working on how to get the airplanes to appear at same location as the airports
    set-default-shape turtles "airplane" ;; for fun and authenticity
    reset-ticks
end

to go
  ask turtles [fly] ;; asks turtles to fly to an airport
  new-airport ;; creates new airports after a set # of ticks
  tick
end

to new-airport
  if remainder ticks 25 = 0 ;; this is asking if the total number of ticks divided by twenty five leaves no remainder. this way this procedure will happen only every 25 ticks
  [ask patch  random-pxcor random-pycor 
    [ set pcolor green  set num-of-flights  0  
      set airport-id airport-count 
      set airport-count airport-count + 1]  ;; makes a new airport with a new airport-id
    crt 1 [set color red setxy random-xcor random-ycor] ;; and a new airplane
    ask patches with [pcolor = green] 
    [set airport? true] ]

end
  
  
to fly
 pd ;; so it leaves a nice path we can see
land
end
     

to land  ;; turtle procedure
  ifelse airport? 
  [depart] ;; if the patch the turtle is on right now is an airport, it's time to depart and find a new airport
  [ let airports patches with [airport? = true]  ;; this let command tells the turtles that all patches that answer true to airport? are in fact airports
   face one-of airports ;; this tells the turtle to choose just one of the patches it now knows it an airport to face (changes turtle's heading so it heads toward the airport)
   while [airport? = false] [ fd 1 ] ]  ;; as long as the turtle is on a patch that is not an airport it will keep moving forward in it's given heading. 
end

 
to depart
 set heading random 170 ;; just to add some randomness
  ask patch-here [set num-of-flights num-of-flights + 1]
 fd 1
land ;; so the turtle will continue to look for another airport
end
@#$#@#$#@
GRAPHICS-WINDOW
210
10
649
470
16
16
13.0
1
10
1
1
1
0
1
1
1
-16
16
-16
16
0
0
1
ticks
30.0

BUTTON
57
49
123
82
NIL
Setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
70
126
133
159
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
35
206
207
239
initial-airports
initial-airports
0
10
3
1
1
NIL
HORIZONTAL

PLOT
12
292
212
442
plot 1
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 1 -16777216 true "" "ask patches with [airport?] [plotxy airport-id num-of-flights]"

@#$#@#$#@
## WHAT IS IT?
This model depicts airplanes flying between airports.  It is meant to demonstrate the phenonmenon of how "hub" airports form.  Over time new airports are built, but you can see that the airports that have existed for the longest still have the greatest number of airplanes flying to them.

## HOW IT WORKS

We  start with a few airports and airplanes that appear on the screen at random locations.  At each tick, the airplanes find a random airport and fly to it, leaving trails to show their paths.  Every 25 ticks, a new airport and a new airplane are built.

The airports are identified as green patches that have the property airport? = true. The airplanes are turtles that are asked to fly between airports.  To do this, each turtle first checks if the patch it's currently on is airport? = true.   If the patch the turtle is currently on is not an airport, the turtle chooses one of the airports at random to face.  Then, as long as the turtle is on a patch that is not an airport, it will keep moving forward in it's given heading. That way it will eventually come to the airport it's facing.  Once the turtle recognizes that the patch it's on is an airport, (airport? = true) the airplane departs, which means it chooses a random heading and flies to a random airport.

## HOW TO USE IT

For this model, it helps to view it at a slower than normal speed.  Use the slider to choose the number of initial airports and airplanes.  Then click on setup to make those appear.  Clicking go will cause the airplanes to start flying.

The plot shows the airports on the x-axis (with the most recently created airports on the right).  The number of flights that have departed from each airport are shown on the y-axis.

## THINGS TO NOTICE
You should notice that, over time, there are more path lines from the airports that were around the longest.  Check this out on the plot!


## THINGS TO TRY

Right click on an airport and inspect the patch. You can see the exact number of flights that have departed from that airport.

## EXTENDING THE MODEL

Challenge #1 Right now the planes randomly choose a new airport to fly to.  Sometimes the airplane will end up trying to fly to the airport it's already at.  Can you help us fix that bug?

Challenge #2 Try to get each new airplane, as it's created, start out at the newest airport.


## CREDITS AND REFERENCES

This was created by Laurel Schrementi and Ellen Fitzmorris. Thanks to our wonderful TAs for helping us out!
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0RC7
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
